<?php
/* ******************************************************************
 * Generator Torgsoft sal file for Хорошоп                 2024-08-28
 * Copyright © FinBoss 2024
 * finboss.ua@gmail.com
 * 
 * вивантаження замовлень
 *  
 * License: Commercial open source software (COSS)  
 ********************************************************************
 */

	@set_time_limit(0);
	
	error_reporting (E_ALL & ~E_STRICT);
	
	header('Content-Type: text/html; charset=utf-8');
	
	$path_parts = pathinfo(__FILE__);				//	используется для установки пути
	$cron_prefix = $path_parts['dirname'].'/';		//	используется для установки пути
	
	$config = array();

	
	$h_site_ssl_select = config_get('h_site_ssl_select');
	$h_domain = config_get('h_domain');
	$h_login = config_get('h_login');
	$h_password = config_get('h_password');
	
	// получение token
	$url = $h_site_ssl_select.'://'.$h_domain.'/api/auth/?login='.$h_login.'&password='.$h_password;
	
	$string = curl_get_contents($url);
	
	$data = json_decode($string, true);
	
	if (isset($data['status']) AND $data['status'] == 'OK'){
		$token = $data['response']['token'];
	}else{
		die("Помилка: Не вдалося авторизуватись на сайті '$h_site_ssl_select://$h_domain'");
	}
	
	
	
	
	$trs_dir = $cron_prefix.'../'.dirname(config_get('oc_loader_torgsoft_trs_file')).'/';
		
	if (is_dir($trs_dir)){
		write_orders();
	}else{
		die ("Помилка: не знайдено папку для запису файлів із замовленнями ".$trs_dir);
	}

// *************************************************************
	
	// вывод в файл
	function write_orders(){

		global 	$cron_prefix, $trs_dir, $token;
		global $h_site_ssl_select, $h_domain;
		
		// выборка заказов
		$status_1 = config_get('oc_loader_torgsoft_text_entry_order_status_to_exchange');
		$status_2 = config_get('oc_loader_torgsoft_text_entry_order_status');
		
		// получения списка заказов
		$url = $h_site_ssl_select.'://'.$h_domain."/api/orders/get/?token=$token&status=$status_1";
		
		$string = curl_get_contents($url);
		
		$data = json_decode($string, true);
		
		if (isset($data['status']) AND $data['status'] == 'OK'){
			$result = $data['response']['orders'];
		}else if (isset($data['status']) AND $data['status'] == 'EMPTY'){
			die('Немає замовлень зі статусом: '.$status_1);
		}else{
			die("Помилка: Не вдалося отримати дані за посиланням 'api/orders/get'");
		}
		
		if (count($result) > 0){
			
			foreach ($result as $order){
				
				$order_id = $order['order_id'];
				
				echo "\r\n<br />".$order_id;
				
// 				$order = getOrder($order_id);
				
				$date_array = explode('-', substr(date('Y-m-d H:i:s'), 0, strpos(date('Y-m-d H:i:s'), ' ')));
			
				// вывод в файл в кодировке 1251
				$file_name = $trs_dir.'order'.$order_id.'.sal';
				
				file_put_contents($file_name, "[Client]\r\n");	// (Блок информации о клиенте)
			
				file_put_contents($file_name, "Name=".iconv('UTF-8', 'CP1251', $order['delivery_name'])."\r\n", FILE_APPEND);
				file_put_contents($file_name, "Mphone=".iconv('UTF-8', 'CP1251', $order['delivery_phone'])."\r\n", FILE_APPEND);
				file_put_contents($file_name, "CPhone=".iconv('UTF-8', 'CP1251', $order['delivery_phone'])."\r\n", FILE_APPEND);
				file_put_contents($file_name, "ZIP=".iconv('UTF-8', 'CP1251', '00000')."\r\n", FILE_APPEND);
				file_put_contents($file_name, "Country=".iconv('UTF-8', 'CP1251', 'Украина')."\r\n", FILE_APPEND);
				file_put_contents($file_name, "Region=".iconv('UTF-8', 'CP1251', '')."\r\n", FILE_APPEND);
				file_put_contents($file_name, "City=".iconv('UTF-8', 'CP1251', $order['delivery_city'])."\r\n", FILE_APPEND);
				file_put_contents($file_name, "Address=".iconv('UTF-8', 'CP1251', $order['delivery_address'])."\r\n", FILE_APPEND);
				file_put_contents($file_name, "EMail=".iconv('UTF-8', 'CP1251', $order['delivery_email'])."\r\n", FILE_APPEND);
				
				file_put_contents($file_name, "\r\n", FILE_APPEND);
				
				file_put_contents($file_name, "[Options]\r\n", FILE_APPEND); // (Блок информации о заказе)
				file_put_contents($file_name, "OrderNumber=".iconv('UTF-8', 'CP1251', $order_id)."\r\n", FILE_APPEND);
				file_put_contents($file_name, "Comment=".iconv('UTF-8', 'CP1251', $order['comment'])."\r\n", FILE_APPEND);
				file_put_contents($file_name, "DeliveryCondition=".iconv('UTF-8', 'CP1251', $order['delivery_type']['title'])."\r\n", FILE_APPEND);
				file_put_contents($file_name, "ReserveDate=".iconv('UTF-8', 'CP1251', $date_array[2].$date_array[1].$date_array[0])."\r\n", FILE_APPEND);
				file_put_contents($file_name, "SaleType=".iconv('UTF-8', 'CP1251', '1')."\r\n", FILE_APPEND);
				
				$products = $order['products'];
				
				$p = 0;
				
				foreach ($products as $product){

					file_put_contents($file_name, "\r\n", FILE_APPEND);
					
					if (strpos($product['article'], '-') !== false){
						
						$article_array = explode('-', $product['article']);
						$GoodID = array_pop($article_array);
						
						file_put_contents($file_name, "[$p]\r\n", FILE_APPEND); // (Блок информации о первом товаре заказа)
						file_put_contents($file_name, "GoodID=".iconv('UTF-8', 'CP1251', $GoodID)."\r\n", FILE_APPEND);  // (Ключ товара)
						file_put_contents($file_name, "Price=".iconv('UTF-8', 'CP1251', $product['price'])."\r\n", FILE_APPEND); // (Цена продажи товара)
						file_put_contents($file_name, "Count=".iconv('UTF-8', 'CP1251', $product['quantity'])."\r\n", FILE_APPEND); // (Количество заказанного товара)
						
						$p++;
					}
				}
				
				// изменение статуса заказа
				$order_data = array(
						'order_id' => $order_id,
						'status' => $status_2
				);
				
				
				$url = $h_site_ssl_select.'://'.$h_domain."/api/orders/update/";
				
				$orders = array();
				$orders[] = $order_data;
				
				$send_data = array(
						'token' => $token,
						'orders' => $orders
				);
				
				$string = curl_post($url, $send_data);
				
				$result = json_decode($string, true);
				
				if (isset($result['status'])){
					if ($result['status'] == 'OK'){
						
					}else{
						if ($result['status'] != 'WARNING'){
							write_to_log("Помилка: Не вдалося передати інформацію про замовлення на посилання '$url'. Ответ сервера '$string'".date(" Y-m-d H:i:s"));
							die;
						}else{
							write_to_log("Попередження: Відповідь сервера '$string'".date(" Y-m-d H:i:s"));
						}
					}
				}else{
					write_to_log("Помилка: Не вдалося передати інформацію про замовлення на посилання '$url'. Ответ сервера '$string'".date(" Y-m-d H:i:s"));
					die;
				}
				
				chmod($file_name, 0775);
			}
			
		}else{
			echo 'Немає замовлень зі статусом: '.$status_1;
		}

	}
	

//*********************************************** служебные функции

function config_get($key){
	
	global $config, $cron_prefix;
	
	if (isset($config[$key])){
		return $config[$key];
	}else{
		
		$data = file($cron_prefix.'horoshop_loader_torgsoft.cfg.php', FILE_IGNORE_NEW_LINES);
		
		foreach ($data as $string){
			if ($string[0] == '$'){
				list($parameter, $comment) = explode('//', $string);
				list($variable, $value) = explode('=', trim($parameter), 2);
				$value = substr(trim($value), 0, -1);  // удаляем ;
				$value = str_replace("'", '', trim($value));
				if (strpos($variable, '_textarea') == false){
					if (strpos($variable, 'oc_loader_torgsoft_option_') == false){
						if (strpos($variable, '_bool') == false){
							$config[substr($variable, 1)] = $value;
						}else{
							if ($value){
								$config[str_replace('_bool', '', substr($variable, 1))] = 1;
							}else{
								$config[str_replace('_bool', '', substr($variable, 1))] = 0;
							}
						}
					}else{
						$config['oc_loader_torgsoft_option_'.$value] = $value;
					}
				}else{
					$base = str_replace('_textarea', '', substr($variable, 1));
					$config[$base] = $value;
				}
			}
		}
		
		$config['oc_loader_torgsoft_status']='1';							// статус
		
		$config['oc_loader_torgsoft_cache']='';
		
		if (isset($config[$key])){
			return $config[$key];
		}else{
			return false;
		}
	}
}

function curl_get_contents($url, array $get = array(), array $options = array())
{    
	
    $defaults = array(
       CURLOPT_URL => $url. (strpos($url, '?') === FALSE ? '?' : ''). http_build_query($get),
       CURLOPT_HEADER => 0,
       CURLOPT_RETURNTRANSFER => TRUE,
       CURLOPT_FOLLOWLOCATION => 1,
       CURLOPT_TIMEOUT => 60,
       CURLOPT_SSL_VERIFYPEER => false
    );
   
    $ch = curl_init();
    curl_setopt_array($ch, ($options + $defaults));
	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.1.2) Gecko/20090729 Firefox/3.5.2 GTB5');
    if(!$result = curl_exec($ch)) {
       	trigger_error(curl_error($ch));
		$result = 'error: '.curl_error($ch);
    }else{
    	//echo 'OK';
    }
    curl_close($ch);
   
    return $result;
}

function curl_post($url, array $get = NULL, array $options = array())
{
	$defaults = array(
			CURLOPT_URL => $url,
			//CURLOPT_HEADER => 0,
			CURLOPT_RETURNTRANSFER => TRUE,
			CURLOPT_FOLLOWLOCATION => 1,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_SSL_VERIFYPEER => false,
			CURLOPT_HTTPHEADER => array('Content-type: multipart/form-data')
	);
	
	$ch = curl_init();
	curl_setopt_array($ch, ($options + $defaults));
	curl_setopt( $ch, CURLOPT_POST, true );
	$postFields = is_array( $get ) ? http_build_query( $get ) : $get;
	curl_setopt( $ch, CURLOPT_POSTFIELDS, $postFields );
	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.1.2) Gecko/20090729 Firefox/3.5.2 GTB5');
	if(!$result = curl_exec($ch)) {
		trigger_error(curl_error($ch));
		$result = 'Error: '.curl_error($ch);
	}else{
		//echo 'авторизация - OK <br/>';
	}
	curl_close($ch);
	
	return $result;
}

function write_to_log($msg){
	echo '<br/>'.$msg."\r\n";
}